
import cadquery as cq

# Create the sketch of the irregular rhombus and close it
rhombus = cq.Workplane("front").polyline([(0, 0), (2, 4), (8, 0), (2, -4)]).close()

# Extrude the rhombus
rhombus = rhombus.extrude(1)

# Create the sketch of the rectangular prism with revised dimensions to better suit the design
rect_prism = cq.Workplane("front").box(2.5, 1, 1.5, centered=(True, True, False))

# Locate the top center edge of the rhombus
top_center_edge = rhombus.faces(">Z").edges("<Y")

# Translate and attach the rectangular prism to the center top edge of the rhombus
rect_prism = rect_prism.translate((0, 0, 0.5))

# Combine the shapes
result = rhombus.union(rect_prism)

# Output the result with the updated file name
result.val().exportStl("Refine_2.stl")
