
import cadquery as cq

cylinder_diameter = 10
cylinder_radius = cylinder_diameter / 2
cylinder_height = 20
cut_width = cylinder_diameter / 4
cut_height = cylinder_height / 4

# Create the main cylinder
cylinder = cq.Workplane("XY").circle(cylinder_radius).extrude(cylinder_height)

# Define the cutting tool with adjusted dimension for cut width also 
# as 1/4th of the cylinder diameter as per feedback
cutting_tool = cq.Workplane("XY") \
    .workplane(offset=cylinder_height - cut_height) \
    .rect(cut_width, cut_width) \
    .extrude(cut_height)

# Perform the cut operation
result = cylinder.cut(cutting_tool)

# Export the final STL file as required
result.val().exportStl("Refine_V_2.stl")
