
import cadquery as cq

table_length = 100.0
table_width = 60.0
table_thickness = 2.0

leg_length = 3.0
leg_width = 3.0
leg_height = 70.0

table_top = cq.Workplane("XY").box(table_length, table_width, table_thickness)

def create_leg(x_offset, y_offset):
    return (
        cq.Workplane("XY")
        .box(leg_length, leg_width, leg_height)
        .translate((x_offset, y_offset, -leg_height / 2 - table_thickness / 2))
    )

# Positioning the legs correctly under each corner of the table top
legs = (
    create_leg(-table_length / 2 + leg_length / 2, -table_width / 2 + leg_width / 2).union(
    create_leg(table_length / 2 - leg_length / 2, -table_width / 2 + leg_width / 2)).union(
    create_leg(-table_length / 2 + leg_length / 2, table_width / 2 - leg_width / 2)).union(
    create_leg(table_length / 2 - leg_length / 2, table_width / 2 - leg_width / 2))
)

table = table_top.union(legs)

table.val().exportStl("Refine_V_2.stl")
