
import cadquery as cq

# Define common variables for length, width, and height
length = 10.0
width = 10.0
height = 0.5

# Create the first rectangle
base = cq.Workplane("XY").box(length, width, height)

# Create the second rectangle, rotated 90 degrees about the origin on the Z-axis
# Attach it along one edge of the first rectangle
second = (cq.Workplane("XY")
          .transformed(offset=(-length/2 + height/2, 0, width/2))
          .transformed(rotate=(0, 90, 0))
          .box(height, width, length))

# Combine the two objects
result = base.union(second)

# Save the result as an STL file
result.val().exportStl("Refine_V_1.stl")
