
import cadquery as cq

# Define dimensions
length = 10.0
width = 5.0
corner_radius = 1.0

# Create a workplane
result = (
    cq.Workplane("XY")
    # Create a rectangle with rounded corners (applying fillet to edges after creating the rectangle)
    .rect(length, width, forConstruction=False)  # Creates the rectangle
    .edges()  # Selects edges of the rectangle
    .fillet(corner_radius)  # Apply fillet to the edges
    .extrude(1.0)  # Extrude the shape to make it 3D
)

# Save the model assuming the .val() call and required export format functions properly as required for your version of Cadquery
result.val().exportStl("Refine_V_1.stl")
