
import cadquery as cq

# Create the first cylinder
cylinder1 = cq.Workplane("XY").circle(10).extrude(20)

# Create the second cylinder, increasing its height to make it taller than the first
cylinder2 = cq.Workplane("XY").circle(8).extrude(40)  # Changed from 30 to 40 for additional height

# Combine both cylinders
result = cylinder1.union(cylinder2)

# Save the result as STL file
result.val().exportStl("Refine_V_1.stl")
