
import cadquery as cq

# Define points of a scalene triangle with one angle greater than 90 degrees
points = [(0, 0), (6, 0), (2, 3)]

# Generate the 2D triangle and extrude into a thin 3D object
result = cq.Workplane("XY").polyline(points).close().extrude(0.1)

# Export the shape to an STL file
result.val().exportStl("Refine_V_2.stl")
