
import cadquery as cq

# Define the points the polyline will be drawn through
points = [(0, 0), (1, 0), (0, 1)]

# Create a workplane, draw the polyline and close it to create a face
r = cq.Workplane("XY").polyline(points).close()

# Extrude the face to create a 3D object
result = r.extrude(1)

# Export the result to an STL file
result.val().exportStl("Generated.stl")
