
import cadquery as cq

# Define the right triangle points
points = [(0, 0), (0, 1), (1, 0)]

# Create a Workplane and a closed polyline forming a right triangle
triangle = cq.Workplane("XY").polyline(points).close()

# Extrude the right triangle to form a 3D object
result = triangle.extrude(1)

# Export the result to an STL file
result.val().exportStl("Refine_V_2.stl")
