
import cadquery as cq

# Define dimensions
length = 100
width = 20
height = 20
radius = 10

# Create rectangular prism
result = cq.Workplane("XY").box(length, width, height)

# Create semi-circle cutout along the entire length
# Positioning the workplane at the bottom of the prism for cutting
result = result.faces(">Z").workplane().center(-length/2+radius, 0)

# Cut a cylinder across the full length
result = result.pushPoints([(-length/2+radius, 0)]).cylinder(height, radius)

# Save the result
result.val().exportStl("Refine_V_1.stl")
