
import cadquery as cq

# Define the dimensions of the object
length = 100
width = 20
height = 20
radius = 10

# Create a rectangular prism
result = cq.Workplane("XY").box(length, width, height)

# Cut a half-cylinder (semi-circle) along the length of the prism
# Start by creating a half-cylinder
half_cylinder = (
    cq.Workplane("YZ")
    .workplane(offset=-length / 2)
    .moveTo(0, height / 2)
    .circle(radius)
    .revolve(angleDegrees=180, axisStart=(0, 0), axisEnd=(length, 0))
)

# Perform the cut operation on the rectangular prism using the half-cylinder
result = result.cut(half_cylinder.translate((0, 0, radius)))

# Export the final model as an STL file
result.val().exportStl("Refine_V_2.stl")
