
import cadquery as cq

# Defining dimensions for the hollow cylinder
outer_radius = 10.0
inner_radius = 7.5  # Adjusted to better represent a "medium-sized" inner radius
height = 200.0

# Creating the outer cylinder
result = cq.Workplane("XY").circle(outer_radius).extrude(height)

# Creating the inner cylinder
inner_cylinder = cq.Workplane("XY").circle(inner_radius).extrude(height)

# Subtracting the inner cylinder from the outer cylinder to create a hollow cylinder
result = result.cut(inner_cylinder)

# Exporting the model to STL format with the updated version name
result.val().exportStl("Refine_V_2.stl")
