
import cadquery as cq

# Parameters for the cylinder and hole
diameter = 100.0  # Diameter of the cylinder
height = 10.0  # Height of the cylinder
hole_diameter = 10.0  # Diameter of the hole

# Create the cylinder
result = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Create the hole
result = result.faces(">Z").workplane().hole(hole_diameter)

# Export the result
result.val().exportStl("Generated.stl")
