
import cadquery as cq

# Increase the diameter to make it visibly large
diameter = 200.0  # Updated from 100.0 to 200.0
height = 10.0
hole_diameter = 10.0

result = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Creating the central hole
result = result.faces(">Z").workplane().hole(hole_diameter)

# Saving the updated model
result.val().exportStl("Refine_V_1.stl")
