
import cadquery as cq

diameter = 500.0  # Increased the diameter to clearly represent a large size
height = 10.0
hole_diameter = 10.0

# Create a large diameter cylinder
result = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Adding a small hole at the center
result = result.faces(">Z").workplane().hole(hole_diameter)

# Export the model to an STL file
result.val().exportStl("Refine_V_2.stl")
