
import cadquery as cq

# Define the dimensions of the table
table_length = 90.0
table_width = 60.0
table_thickness = 2.0

# Define the dimensions of the legs
leg_length = table_length / 3.0
leg_width = 5.0
leg_thickness = table_thickness

# Create the table surface
table = cq.Workplane("XY").box(table_length, table_width, table_thickness)

# Create the legs
leg1 = (
    cq.Workplane("XY")
    .workplane(offset=table_thickness)
    .moveTo(-table_length / 2.0 + leg_length / 2.0, 0)
    .box(leg_length, leg_width, leg_thickness)
)

leg2 = (
    cq.Workplane("XY")
    .workplane(offset=table_thickness)
    .moveTo(table_length / 2.0 - leg_length / 2.0, 0)
    .box(leg_length, leg_width, leg_thickness)
)

# Combine the table and the legs
result = table.union(leg1).union(leg2)

# Export the result
result.val().exportStl("Generated.stl")
