
import cadquery as cq

# Dimensions of the table
table_length = 90.0
table_width = 60.0
table_thickness = 2.0

# Dimensions of the legs
leg_length = table_length / 3.0
leg_width = 5.0
leg_height = 30.0  # Typical height for desk legs

# Create the table top
table = cq.Workplane("XY").box(table_length, table_width, table_thickness)

# Create the first leg, positioned on the left side of the table
leg1 = (
    cq.Workplane("XY")
    .workplane(offset=-leg_height)  # Start below the table surface
    .moveTo(-table_length / 2 + leg_width / 2, 0)  # Position to the left side
    .box(leg_width, leg_width, leg_height)
)

# Create the second leg, positioned on the right side of the table
leg2 = (
    cq.Workplane("XY")
    .workplane(offset=-leg_height)  # Start below the table surface
    .moveTo(table_length / 2 - leg_width / 2, 0)  # Position to the right side
    .box(leg_width, leg_width, leg_height)
)

# Combine the table with the legs
result = table.union(leg1).union(leg2)

# Save the final output
result.val().exportStl("Refine_V_1.stl")
