
import cadquery as cq

# Dimensions for the rectangle
rect_length = 30.0
rect_width = 10.0
rect_height = 5.0

# Calculating the side length of the squares based on area ratio and requirement
# The area of the square on the left is 75% smaller than the right
# Area_right = ka
# Area_left = 0.25ka => Side_left = sqrt(0.25) * Side_right
large_square_side = 4.0  # arbitrary choice for the size of the large square
small_square_side = large_square_side * (0.25**0.5)  # smaller square side, 75% smaller in area

# Heights of the squares
small_square_height = 5.0
large_square_height = 2 * small_square_height  # larger square is extruded twice the smaller

# Main rectangle
result = cq.Workplane("XY").box(rect_length, rect_width, rect_height)

# Small square on the left edge of the rectangle
result = result.faces(">Y").workplane().moveTo(-rect_length/2 - small_square_side/2, 0).box(small_square_side, small_square_side, small_square_height)

# Large square on the right edge of the rectangle
result = result.faces(">Y").workplane().moveTo(rect_length/2 + large_square_side/2, 0).box(large_square_side, large_square_side, large_square_height)

# Export to STL
result.val().exportStl("Refine_V_1.stl")
