
import cadquery as cq

# Rectangular base dimensions
rect_length = 30.0
rect_width = 10.0
rect_height = 5.0

# Calculating the sides of the squares based on the feedback
# If the large square side is `x`, then small square side is x * sqrt(0.25)
large_square_side = 4.0
small_square_side = large_square_side * (0.25**0.5)

# Heights of extrusions for the squares
small_square_height = 5.0
large_square_height = 2 * small_square_height

# Creating the base rectangle
result = cq.Workplane("XY").box(rect_length, rect_width, rect_height)

# Adding the smaller square (75% smaller in area) to the left of the rectangle
result = result.faces(">Y").workplane().moveTo(-rect_length/2 - small_square_side/2, 0).box(small_square_side, small_square_side, small_square_height, combine=True)

# Adding the larger square to the right of the rectangle
result = result.faces(">Y").workplane().moveTo(rect_length/2 + large_square_side/2, 0).box(large_square_side, large_square_side, large_square_height, combine=True)

# Save the resultant model to an STL file
result.val().exportStl("Refine_V_2.stl")
