
import cadquery as cq

# Define the side length of the hexagon
side_length = 10.0

# Create a workplane
result = cq.Workplane("XY")

# Draw the hexagon
result = result.polyline([(side_length / 2, 0), 
                          (side_length / 2, side_length), 
                          (0, side_length * 1.5), 
                          (-side_length / 2, side_length), 
                          (-side_length / 2, 0), 
                          (0, -side_length / 2)]).close()

# Extrude to create a 3D object
result = result.extrude(5.0)

# Export the result to STL
result.val().exportStl("Generated.stl")
