
import cadquery as cq
import math

side_length = 10.0
# Calculate the radius of the circumcircle which fits all vertices of the hexagon
radius = side_length / math.sqrt(3)

# Create a new workplane that represents the XY plane
result = cq.Workplane("XY")

# Generate the six points describing the hexagon
# Using a loop to create vertex points around the circle for every 60 degrees (360/6)
for i in range(6):
    angle_deg = 60 * i
    angle_rad = math.radians(angle_deg)
    result = result.lineTo(radius * math.cos(angle_rad), radius * math.sin(angle_rad))

# Close the polyline to make it a continuous loop and then extrude it
result = result.close().extrude(5.0)

# Export the final shape as STL
result.val().exportStl("Refine_V_1.stl")
