
import cadquery as cq

# Create the base rectangle and extrude
result = cq.Workplane("front").rect(10, 5).extrude(1)

# Create a smaller rectangle on top and extrude
result = result.faces(">Z").workplane().rect(8, 5).extrude(1)

# Now create the trapezoid on top, ensuring it is wider and aligned
trapezoid_profile = [
    (-4.5, 0),   # Start from the left-bottom point
    (4.5, 0),    # To the right-bottom point
    (5.5, 2),    # To the right-top point, make this slightly wider
    (-5.5, 2)    # End at the left-top point
]
result = result.faces(">Y").workplane(centerOption="CenterOfBoundBox").polyline(trapezoid_profile).close().extrude(1)

# Export to STL
result.val().exportStl("Refine_V_1.stl")
