
import cadquery as cq

# Base rectangle
result = cq.Workplane("front").rect(10, 5).extrude(1)

# Second rectangle
result = result.faces(">Z").workplane().rect(8, 5).extrude(1)

# Isosceles trapezoid
trapezoid_profile = [
    (-4.5, 0),  # Lower left point, half of the slightly smaller second rectangle -0.5
    (4.5, 0),   # Lower right point
    (5, 2),     # Upper right point, slightly wider than the second rectangle
    (-5, 2)     # Upper left point
]

# Adding the trapezoid to the structure
result = result.faces(">Z").workplane(centerOption="CenterOfBoundBox").polyline(trapezoid_profile).close().extrude(1)

# Export to STL
result.val().exportStl("Refine_V_2.stl")
