
import cadquery as cq

# Updated dimensions to enhance wideness and emphasize shortness in height
length = 100.0  # Keeping the length the same to maintain 'long' aspect
width = 75.0    # Increased width to make the object look wider
height = 5.0    # Decreased height to make the object shorter

result = (
    cq.Workplane("XY")
    .box(length, width, height)
)

# Saving the modified object model as an STL file with new name
result.val().exportStl("Refine_V_1.stl")
