
import cadquery as cq

# Define dimensions based on updated specifications
rect_width = 10.0  # width of the rectangle
rect_length = rect_width * 5  # length is 5 times the width
rect_height = 5.0  # height of the rectangle
cylinder_radius = rect_width / 3  # radius of cylinder
cylinder_height = rect_height * 2  # height of cylinder

# Create the base rectangle
result = cq.Workplane("XY").box(rect_length, rect_width, rect_height)

# Create the cylinder and position it on one side very close to the edge
result = result.faces(">Y").workplane()\
    .moveTo(-rect_length / 2 + cylinder_radius, 0)\
    .circle(cylinder_radius).extrude(cylinder_height)

# Export the resulting model to an STL file
result.val().exportStl("Refine_V_1.stl")
