
import cadquery as cq

cube_size = 10.0  # Size of the large cube

# Create the large cube
cube = cq.Workplane("XY").box(cube_size, cube_size, cube_size)

prism_size = cube_size / 4.0  # Size of the triangular prism, which is 1/4th the size of the cube

# Define the right triangular prism
prism = (
    cq.Workplane("XY")
    .moveTo(0, 0)
    .lineTo(0, prism_size)
    .lineTo(prism_size, prism_size)
    .lineTo(prism_size, 0)
    .close()
    .extrude(prism_size)
)

# Position the triangular prism correctly by aligning it to the cube
prism = prism.translate((cube_size - prism_size, 0, 0))

# Union the two shapes into one object
result = cube.union(prism)

# Save the model as STL
result.val().exportStl("Refine_V_1.stl")
