
import cadquery as cq

# Create a cylinder with a diameter of 20 units (radius is 10) and height of 5 units
cylinder = cq.Workplane("XY").circle(10.0).extrude(5.0)

# Create a rectangular prism with a length slightly larger than the cylinder's diameter,
# and arbitrarily chosen narrow width and height (maintaining short and narrow characteristics).
# Positioned to sit on top of the cylinder.
rect_prism = cq.Workplane("XY").box(22.0, 2.0, 2.0).translate((0, 0, 5))

# Union the cylinder and the rectangular prism
result = cylinder.union(rect_prism)

# Save as STL file
result.val().exportStl("Refine_V_2.stl")
