
import cadquery as cq

# Define the dimensions of the rectangle and rod
rectangle_length = 15.0
rectangle_width = rectangle_length / 1.5
rectangle_thickness = 0.5
rod_length = 1.0
rod_width = 1.0
rod_height = rectangle_length * 3  # Rod height is 3 times the rectangle's length

# Create the base rectangle
result = (
    cq.Workplane("XY")
    .rect(rectangle_length, rectangle_width)
    .extrude(rectangle_thickness)
)

# Position and create the rod at one of the corners of the rectangle
# Since it's at a corner, it uses the exact edge of the rectangle minus half the width and length of the rod
result = (
    result
    .faces(">Z")
    .workplane(centerOption="CenterOfMass")
    .transformed(offset=(rectangle_length / 2 - rod_length / 2, rectangle_width / 2 - rod_width / 2, 0))
    .rect(rod_length, rod_width)
    .extrude(rod_height)
)

# Export the adjusted model as an STL file
result.val().exportStl("Refine_V_2.stl")
