
import cadquery as cq

# Define the dimensions
width = 10.0
height = 20.0
thickness = 2.0
radius = width / 2.0
hole_diameter = radius / 2.0

# Create the tag
result = (
    cq.Workplane("front")
    .rect(width, height - radius)  # Draw the rectangle
    .moveTo(width / 2.0, height - radius)  # Move to the center of the semicircle
    .threePointArc((0, height), (width, height - radius))  # Draw the semicircle
    .extrude(thickness)  # Extrude the sketch
    .faces(">Z")  # Select the top face
    .workplane()  # Create a new workplane
    .hole(hole_diameter)  # Create the hole
)

# Export the result
result.val().exportStl("Generated.stl")
