
import cadquery as cq

# Dimension specifications
width = 10.0
height = 20.0
thickness = 1.0

# Semi-circle radius to fit width
radius = width / 2.0

# Calculate the hole diameter to be 1/4th of the semi-circle's diameter
hole_diameter = radius / 2.0

result = (
    cq.Workplane("front")
    # Start the drawing
    .moveTo(-radius, 0)

    # Draw the semi-circle at the bottom
    .threePointArc((0, -radius), (radius, 0))

    # Draw the vertical lines up the sides
    .vLineTo(height - radius)
    .hLineTo(-width)
    .vLineTo(radius)

    # Complete the sketch - creates a U-shape
    .close()

    # Extrude to create the 3D object
    .extrude(thickness)

    # Adding the circular cutout
    .faces(">Z")  # select the top face
    .workplane(centerOption="CenterOfMass")
    .circle(hole_diameter / 2).cutThruAll()  # Cut a hole
)

# Save the result
result.val().exportStl("Refine_V_2.stl")
