
import cadquery as cq

# Define dimensions
length = 100.0
width = 20.0
height = 20.0
cutout_length = length / 4
cutout_height = height * 3 / 4
cutout_width = width

# Create main rectangular prism
result = cq.Workplane("XY").box(length, width, height)

# Create the cutout; adjusted placement to exact 3/4 position on the height, and alignment to the right side of the prism
cutout = (
    cq.Workplane("XY")
    .workplane(offset=height - cutout_height)
    .moveTo(length - cutout_length / 2, 0)
    .rect(cutout_length, cutout_width)
    .extrude(cutout_height, combine=False)
)

# Subtract the cutout from the original prism
result = result.cut(cutout)

# Export the final model
result.val().exportStl("Refine_V_1.stl")
