
import cadquery as cq

length = 10
width = 5
radius = width / 2  # Determines the radius for the semi-circular ends
thickness = 0.1

# Define the base shape with semi-circular ends
# We create a rectangle and add Two Three-Point Arcs at the ends
result = cq.Workplane("XY")\
            .moveTo(-length/2, 0)\
            .lineTo(length/2 - radius, 0)\
            .threePointArc((length/2, radius), (length/2 - radius, width))\
            .lineTo(-length/2 + radius, width)\
            .threePointArc((-length/2, width - radius), (-length/2 + radius, 0))\
            .close()

# Extrude the shape to the specified thickness
result = result.extrude(thickness)

# Dimensions for the hole placement
hole_diameter = 0.5
hole_offset = radius  # Position hole at center of semi-circular ends

# Adding the holes
result = result.faces(">Z").workplane()\
                  .pushPoints([(-length/2 + hole_offset, width/2), (length/2 - hole_offset, width/2)])\
                  .hole(hole_diameter)

result.val().exportStl("Refine_V_2.stl")
