
import cadquery as cq

# Parameters to define the appearance of irregularity in the slot
length_variation = 0.1  # Control the variation in length of the slit across different cuts

# Base rectangle block
result = cq.Workplane("XY").rect(10, 20).extrude(5)

# Circular hole
result = result.faces(">Z").workplane().circle(2).cutThruAll()

# Irregular slit by adding multiple tiny rectangular cuts to simulate edges being rough
for i in range(5):
    length = 10 + (-length_variation if i % 2 == 0 else length_variation)
    result = result.faces(">Z").workplane().moveTo(0, 10).rect(0.2, length).cutThruAll()

# Output the model to an STL file
result.val().exportStl("Refine_V_1.stl")
