
import cadquery as cq

# Create a new workplane that is the XY plane, create a rectangle on it, and then extrude
result = cq.Workplane("front").rect(10, 10).extrude(5)

# Select the top face and add a hole in the center
result = result.faces(">Z").workplane().hole(4)

# Add two small holes, one on the left and one on the right of the central hole
result = result.faces(">Z").workplane().center(-3, 0).hole(1)
result = result.faces(">Z").workplane().center(3, 0).hole(1)

# Save the result to an STL file named "Refine_V_1.stl"
result.val().exportStl("Refine_V_1.stl")
