
import cadquery as cq

circle_dia = 10.0  # Diameter of the main circle
hole_dia = 1.0     # Diameter of each hole
hole_offset = 3.0  # Distance from the center to the hole centers

# Create a workplane, a circle on it, and extrude to form a cylinder
result = cq.Workplane("XY").circle(circle_dia / 2.0).extrude(1.0)

# Add holes in a square pattern
for x in [-hole_offset, hole_offset]:
    for y in [-hole_offset, hole_offset]:
        result = result.faces(">Z").workplane().center(x, y).hole(hole_dia)

# Save the resulting model as STL
result.val().exportStl("Refine_V_1.stl")
