
import cadquery as cq

# Define dimensions
U_width = 10.0
U_height = 20.0
U_thickness = 2.0
rectangle_width = U_width + 4 * U_thickness  # Ensuring the rectangle is wider than the U's width
rectangle_height = U_thickness
extrusion_depth = 10.0

# Create a U-shaped base with hollow middle
u_shape_base = cq.Workplane("front")\
    .moveTo(-U_width / 2 - U_thickness, 0)\
    .lineTo(-U_width / 2 - U_thickness, U_height)\
    .lineTo(-U_width / 2, U_height)\
    .lineTo(-U_width / 2, U_thickness)\
    .lineTo(U_width / 2, U_thickness)\
    .lineTo(U_width / 2, U_height)\
    .lineTo(U_width / 2 + U_thickness, U_height)\
    .lineTo(U_width / 2 + U_thickness, 0)\
    .close()\
    .extrude(extrusion_depth)

# Create rectangle top wider than the U-shape
rectangle = cq.Workplane("front")\
    .moveTo(0, U_height + U_thickness / 2)\
    .rect(rectangle_width, rectangle_height)\
    .extrude(extrusion_depth)

# Union the U-shape and rectangle top
result = u_shape_base.union(rectangle)

# Save the model as STL file
result.val().exportStl("Refine_V_2.stl")
