
import cadquery as cq

# Step 1: Create a cylinder with height twice its diameter, i.e., d = 10, h = 20
diameter = 10
height = 2 * diameter
cylinder = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Step 2: Cut the cylinder to remove exactly 1/3 of the material
# Slicing the cylinder diagonally and removing 1/3rd requires careful planning of the cut angles and shapes
# Create a wedge that will cut 1/3 of the cylinder when combined with a box
# The dimensions are chosen to ensure the wedge intersects 1/3rd of the cylinder volume
cutting_wedge = (
    cq.Workplane("XY")
    .transformed(offset=(-5, 0, height / 4), rotate=(0, 15, 0))
    .box(height, 1.5 * height, height / 2)
)

cut_part = (
    cylinder.cut(cutting_wedge)
)

# Step 3: Output manipulation
sliced_cylinder = cut_part

# Save to STL file
sliced_cylinder.val().exportStl("Refine_V_1.stl")
