
import cadquery as cq

# Define the parameters
diameter = 10
height = 2 * diameter  # Height is twice the diameter

# Create the cylinder
cylinder = cq.Workplane("XY").circle(diameter / 2).extrude(height)

# Create the cutting wedge
# To slice exactly half at an angle and remove 1/3rd, adjust the box size and position
cutting_wedge = (
    cq.Workplane("XY")
    .transformed(offset=(0, 0, height / 2), rotate=(0, 15, 0))  # Rotate at an angle
    .box(diameter * 1.5, diameter, height, centered=(True, True, False))
    .translate((0, -diameter / 4, 0))  # Adjust position to remove 1/3rd volume
)

# Cut the cylinder with the wedge
cut_part = cylinder.cut(cutting_wedge)

# Final object to be exported
sliced_cylinder = cut_part

# Export the model to STL
sliced_cylinder.val().exportStl("Refine_V_2.stl")
