
import cadquery as cq

# Create a square base object by defining a rectangle with equal side lengths and extruding it
result = cq.Workplane("XY").box(10, 10, 10)

# Cut a tiny rectangular hole in the center of the square
result = result.faces(">Z").workplane().rect(1, 1).cutBlind(-10)  # cutBlind is used to specify the depth of the cut

# Export the model as STL
result.val().exportStl("Refine_V_1.stl")
