
import cadquery as cq

# Create a thin rectangular prism (square shape) with dimensions 10x10x1
result = cq.Workplane("XY").box(10, 10, 1)

# Cut a tiny rectangular hole at the center of the square
result = result.faces(">Z").workplane().rect(1, 1).cutBlind(-1)

# Export the adjusted model to an STL file
result.val().exportStl("Refine_V_2.stl")
