
import cadquery as cq

outer_size = 10.0
inner_size = 8.0
length = 20.0

# Create the outer rectangle
result = cq.Workplane("XZ").rect(outer_size, outer_size).extrude(length)

# Create the inner rectangle on one face and cut through the entire length
result = result.faces(">Y").workplane().rect(inner_size, inner_size).cutThruAll()

# Ensure that the hole formed by the inner square is centered accurately and cuts through the entire object
result = result.faces("<Y").workplane(centerOption="CenterOfBoundBox").rect(inner_size, inner_size).cutThruAll()

# Export the refined model to STL
result.val().exportStl("Refine_V_2.stl")
