
import cadquery as cq

# Points that define a simple rhombus in the XY plane
points = [(0, 0), (2, 1), (4, 0), (2, -1)]

# Create a workplane that the rhombus will be drawn on, then draw the rhombus and extrude
result = cq.Workplane("XY").polyline(points).close().extrude(1)

# Export the result to an STL file
result.val().exportStl("Refine_V_1.stl")
