
import cadquery as cq

frame_size = 10.0
frame_thickness = 1.0

# Create a workplane to base future operations on
wp = cq.Workplane("XY")

# Create outer square
outer_square = wp.rect(frame_size, frame_size).extrude(frame_thickness)

# Create inner square, inset by the frame thickness
inner_square = wp.rect(frame_size - 2 * frame_thickness, frame_size - 2 * frame_thickness).extrude(frame_thickness)

# Subtract the inner square from the outer square to create a frame
frame = outer_square.cut(inner_square)

# Rotate the frame to ensure the square is aligned horizontally if needed (as in feedback seems to misunderstand perspective)
frame = frame.rotate((1, 0, 0), (0, 1, 0), 45)

# Export to STL
frame.val().exportStl("Refine_V_1.stl")
