
import cadquery as cq

frame_size = 10.0
frame_thickness = 1.0

wp = cq.Workplane("XY")

outer_square = wp.rect(frame_size, frame_size).extrude(frame_thickness)

inner_square = wp.rect(frame_size - 2 * frame_thickness, frame_size - 2 * frame_thickness).extrude(frame_thickness)

frame = outer_square.cut(inner_square)  # Removed rotate operation

frame.val().exportStl("Refine_V_2.stl")
