
import cadquery as cq

# Define dimensions
pipe_od = 10.0  # Outer diameter of the pipe
pipe_id = 8.0   # Inner diameter of the pipe
pipe_length = 50.0  # Length of the pipe
flange_od = 15.0  # Outer diameter of the flange
flange_thickness = 1.0  # Thickness of the flange

# Create the hollow pipe by extruding the outer diameter and then cutting out the inner diameter
pipe = (
    cq.Workplane("XY")
    .circle(pipe_od / 2.0)  
    .extrude(pipe_length)
    .faces("<Z")
    .workplane()
    .circle(pipe_id / 2.0)
    .cutThruAll()  # Cuts the inner diameter to hollow the pipe
)

# Create the flange by extruding a larger diameter and then cutting out the inner diameter to match pipe
flange = (
    cq.Workplane("XY")
    .circle(flange_od / 2.0)
    .extrude(flange_thickness)
    .faces("<Z")
    .workplane()
    .circle(pipe_od / 2.0)  # Match the outer pipe diameter for a precise fit
    .cutThruAll()  # Makes the flange hollow to fit the pipe perfectly
)

# Combine the pipe and flange into a single solid model
result = (
    flange.translate((0, 0, -flange_thickness))  # Shift the flange to one end of the pipe
    .union(pipe)
)

# Export the final model to an STL file
result.val().exportStl("Refine_V_1.stl")
