
import cadquery as cq

# Define the dimensions
pipe_od = 10.0  # Outer diameter of the pipe
pipe_id = 8.0   # Inner diameter of the pipe
pipe_length = 50.0  # Length of the pipe
flange_od = 15.0  # Outer diameter of the flange
flange_thickness = 1.0  # Thickness of the flange

# Create the pipe by subtracting the inner circle from the outer circle
pipe = (
    cq.Workplane("XY")
    .circle(pipe_od / 2.0).extrude(pipe_length)  # Positive extrusion for outer circle
    .faces("<Z").workplane().circle(pipe_id / 2.0).cutThruAll()  # Negative extrusion for inner circle
)

# Create the flange by subtracting the pipe diameter from a larger circle
flange = (
    cq.Workplane("XY")
    .circle(flange_od / 2.0).extrude(flange_thickness)  # Positive for outer flange
    .faces("<Z").workplane().circle(pipe_od / 2.0).cutThruAll()  # Negative for pipe diameter cut
)

# Combine flange and pipe
result = (
    flange.translate((0, 0, -flange_thickness))
    .union(pipe)
)

# Export the result as STL file
result.val().exportStl("Refine_V_2.stl")
