
import cadquery as cq

# Define cylinder dimensions and rectangle size
cylinder_radius = 10
cylinder_height = 20
rectangle_width = 5
rectangle_height = 5

# Create the base cylinder
cylinder = cq.Workplane("XY").circle(cylinder_radius).extrude(cylinder_height)

# Cut a centered rectangle through the entire height of the cylinder
# Using `cutThruAll()` to ensure it cuts regardless of height specifics
result = cylinder.faces(">Z").workplane(centerOption="CenterOfBoundBox").rect(rectangle_width, rectangle_height).cutThruAll()

# Export result as STL
result.val().exportStl("Refine_V_1.stl")
