
import cadquery as cq

# Define the parallelogram by specifying its vertices and closing it to form a closed loop
parallelogram = cq.Workplane("XY").polyline([(0, 0), (4, 0), (5, 2), (1, 2)]).close()

# Extrude the parallelogram to create a 3D object
extruded = parallelogram.extrude(10)

# Select the top face of the extruded parallelogram and draw a rectangle on it.
# The rectangle is centered and properly sized to represent a visible square hole
square = extruded.faces(">Z").workplane().rect(3, 3)

# Cut the square through the entire extruded parallelogram to make the hole visible
result = square.cutThruAll()

# Export to STL with the corrected visibility of the square hole
result.val().exportStl("Refine_V_2.stl")
