
import cadquery as cq

d1 = 10.0  # Diameter of the smaller half of the pipe
d2 = (2.0 / 3.0) * d1  # Adjusting d2 to be 2/3 of d1

l1 = 20.0  # Length of the first half
l2 = 20.0  # Length of the second half

t = 2.0  # Thickness of the pipe

# Create the first half of the pipe
pipe = (
    cq.Workplane("XY")
    .circle(d1 / 2.0 + t)
    .circle(d1 / 2.0).extrude(l1)
)

# Create the second half of the pipe with the adjusted diameter
pipe = (
    pipe.faces(">Z")
    .workplane()
    .circle(d2 / 2.0 + t)
    .circle(d2 / 2.0).extrude(l2)
)

# Export the STL file with the corrected pipe model
pipe.val().exportStl("Refine_V_1.stl")
