
import cadquery as cq

# Define dimensions
d1 = 10.0  # Larger diameter
d2 = (2.0 / 3.0) * d1  # Smaller diameter, which is 2/3 of the larger diameter

l1 = 20.0  # Length of the first section of the pipe with smaller diameter hole
l2 = 20.0  # Length of the second section of the pipe with larger diameter hole

t = 2.0  # Wall thickness

# Create the pipe with two sections having different inner diameters
pipe = (
    cq.Workplane("XY")
    .circle(d1 / 2 + t)  # Outer radius for larger diameter hole
    .circle(d1 / 2).extrude(-l2)  # Begin with the larger hole's section and extrude backwards
    .faces("<Z")  # Select the backward face
    .workplane()
    .circle(d2 / 2 + t)  # Outer radius for smaller diameter hole
    .circle(d2 / 2).extrude(-l1)  # Continue with the smaller hole's section
)

# Export to STL
pipe.val().exportStl("Refine_V_2.stl")
